/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream.network;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.pasterdream.PasterdreamMod;

@Mod.EventBusSubscriber(modid="pasterdream", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OnBossDeathMessage {
    int nbt;
    static final Map<Integer, String> map = Maps.newHashMap();

    public OnBossDeathMessage(int nbtName) {
        this.nbt = nbtName;
    }

    public OnBossDeathMessage(FriendlyByteBuf buffer) {
        this.nbt = buffer.readInt();
    }

    public static void buffer(OnBossDeathMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.nbt);
    }

    public static void handler(OnBossDeathMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> OnBossDeathMessage.lambda$handler$1(message, (Supplier)contextSupplier)));
        context.setPacketHandled(true);
    }

    public static void handlePacket(OnBossDeathMessage message, Supplier<NetworkEvent.Context> ctx) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        player.getPersistentData().m_128473_(map.get(message.nbt));
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PasterdreamMod.addNetworkMessage(OnBossDeathMessage.class, OnBossDeathMessage::buffer, OnBossDeathMessage::new, OnBossDeathMessage::handler);
    }

    private static /* synthetic */ Runnable lambda$handler$1(OnBossDeathMessage message, Supplier contextSupplier) {
        return () -> OnBossDeathMessage.lambda$handler$0(message, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handler$0(OnBossDeathMessage message, Supplier contextSupplier) {
        OnBossDeathMessage.handlePacket(message, contextSupplier);
    }

    static {
        map.put(0, "left_hand_hp");
        map.put(1, "right_hand_hp");
    }
}

